
import unittest
infinity=10000

def printGrid(grid):

    for i in range(3):
        for j in range(3):
            print(str(grid[j+i*3])+" ", end="")
        print()

def emptyCells(grid):
    
    cells=[]
    for i in range(len(grid)):
        if grid[i] =='-': 
            cells.append(i)

    return cells

def win(grid, player):

    p=[[0,1,2],[3,4,5],[6,7,8],[0,3,6],[1,4,7],[2,5,8],[0,4,8],[2,4,6]]

    for i in range(8):
        if grid[p[i][0]] == player and\
           grid[p[i][1]]  == player and\
           grid[p[i][2]]  == player:

            return True

    return False

def minimax(grid, depth, player):

    if player == 'X':
        best = [-1, -infinity]
    else:
        best = [-1, +infinity]
 
    if win(grid, 'X'):
        return [-1, +1]
    elif win(grid, 'O'):
        return [-1, -1]
    elif depth==0:
        return [-1, 0]

    for cell in emptyCells(grid):
    
        grid[cell] = player
        if player=='X':
            score = minimax(grid, depth - 1, 'O')
        else:
            score = minimax(grid, depth - 1, 'X')

        grid[cell] = '-'
        score[0]= cell

        if player == 'X':
            if score[1] > best[1]:
                best = score  
        else:
            if score[1] < best[1]:
                best = score  

    return best

def main():

    grid=['-','-','-','-','-','-','-','-','-']
    printGrid(grid)

    while True:
        
        if win(grid, 'O'):
            print('\nO Wins')
            break
        elif win(grid, 'X'):
            print('\nX Wins')
            break
        elif len(emptyCells(grid))==0:
            print("\nDraw")
            break       

        print()
        print("Player Turn: O")
        pos=int(input("Enter pos 1-9: "))
        grid[pos-1]='O'
        printGrid(grid)

        print()
        print('Computer Turn X')
        depth=len(emptyCells(grid))
        move = minimax(grid, depth, 'X')
        grid[move[0]] = 'X'
        printGrid(grid)

class Test(unittest.TestCase):

    def test1(self):
        grid=['O', '-', '-', '-', 'X', '-', 'O', '-', 'X']
        depth=len(emptyCells(grid))
        move = minimax(grid, depth,  'X')
        self.assertEqual(move[0], 3)
        
    def test2(self):
        grid=['X', 'X', 'O', 'O', 'X', '-', 'O', 'O', '-']
        depth=len(emptyCells(grid))
        move = minimax(grid, depth,  'X')
        self.assertEqual(move[0], 8)

    def test3(self):
        grid=['-','-','O','-','-','O','-','-','O']
        depth=len(emptyCells(grid))
        move = minimax(grid, depth,  'X')
        self.assertEqual(move[0], -1)
    
if __name__ == '__main__':
    main()
    #unittest.main()
