# Genetic Algorithm to solve
# traveing salesman problem

import random
import math
import matplotlib.pyplot as plt


NUM_CITIES=10
NUM_SOLUTIONS=100
MUTATION_RATE=0.1
NUM_MUTATIONS=int(MUTATION_RATE*NUM_SOLUTIONS)
CROSSOVER_RATE=0.1
NUM_CROSSOVERS=int(CROSSOVER_RATE*NUM_SOLUTIONS)
NUM_GENERATIONS=100
GRID_SIZE=100

def min_fitness(population,fitness,cities):

    reorder_cities=[]
    print("")
    f=1000
    for i in range(len(fitness)):
        if fitness[i] < f:
            imin=i
            f=fitness[i]

    print(cities)
    print(population[imin],fitness[imin],imin)
    s=population[imin]
    
    for i in range(NUM_CITIES):
        reorder_cities.append(cities[s[i]])

    reorder_cities.append(reorder_cities[0])

    print(reorder_cities)
    
    plot_cities(reorder_cities)


def bubble_sort(A,B):
    sort=0

    while sort!=1:
        sort=1
        for i in range(len(A)-1):
            
            if A[i] > A[i+1]:

                temp=A[i]
                A[i]=A[i+1]
                A[i+1]=temp

                temp=B[i]
                B[i]=B[i+1]
                B[i+1]=temp
                
                sort=0
    return sort


def generate_cities():

    pos=[]
    
    while len(pos) != NUM_CITIES:
        x=random.randint(1, GRID_SIZE)
        y=random.randint(1, GRID_SIZE)
       
        repeat=False
        
        for j in range(len(pos)):
            if x==pos[j][0] and y==pos[j][1]:
                repeat=True
                break

        if repeat == False:
            pos.append([x,y])
            
    return pos

def generate_random_population():

    population=[]

    while len(population) != NUM_SOLUTIONS:

        solution = []
        
        while len(solution) != NUM_CITIES:

            x=random.randint(0,NUM_CITIES-1)

            repeat=False

            for j in range(len(solution)):
                if x == solution[j]:
                    repeat = True
                    break
                
            if repeat == False:
                solution.append(x)

        for j in range(len(population)):
            if solution==population[j]:
                repeat==True

        if repeat == False:
           population.append(solution) 
            
    return population

def calcuate_fitness(population,cities):
    
    fitness=[]
    
    for path in population:

        distance=0.0
        previous_city=None

        for city in path+[path[0]]:
            if previous_city is not None:
                 distance += math.sqrt((cities[city][0] - cities[previous_city][0])**2 + (cities[city][1] - cities[previous_city][1])**2)
            previous_city=city
        
#        for j in range(1,NUM_CITIES):
#            distance=distance+math.sqrt(((cities[i[j-1]][0]-cities[i[j]][0])**2)+((cities[i[j-1]][1]-cities[i[j]][1])**2))
        
#        distance=distance+math.sqrt(((cities[NUM_CITIES-1][0]-cities[0][0])**2)+((cities[NUM_CITIES-1][1]-cities[0][1])**2))
    
        fitness.append(distance)
    
    return fitness

def reproduce(fitness,population):
    div2=len(population)//2
    for i in range(div2):
        population[i+div2] = population[i]
        fitness[i+div2] = fitness[i]

    return

def mutate(popuation):
    
    mutated=[]

    while len(mutated) != NUM_MUTATIONS:
        n=random.randint(0,NUM_SOLUTIONS-1)
        
        repeat=False
        
        for j in range(len(mutated)):
            if n==mutated[j]:
                repeat=True
                break

        if repeat == False:
            mutated.append(n)
            s=popuation[n]

            pos1=random.randint(0,NUM_CITIES-1)
            pos2=random.randint(0,NUM_CITIES-1)

            while pos1 == pos2:
                pos1=random.randint(0,NUM_CITIES-1)
                pos2=random.randint(0,NUM_CITIES-1)

            temp=s[pos1]
            s[pos1]=s[pos2]
            s[pos2]=temp
         
            popuation[n]=s

    return mutated


def crossover(population,mutated):
    
    c=[]

    while len(c) != NUM_MUTATIONS*2:
        
        s1=random.randint(0,NUM_SOLUTIONS-1)
        s2=random.randint(0,NUM_SOLUTIONS-1)

        repeat=False

        if s1==s2:
            repeat==True
        
        for j in range(len(mutated)):
            if s1==mutated[j] or s2==mutated[j] :
                repeat=True
                break

        for j in range(len(c)):
            if s1==c[j] or s2==c[j]:
                repeat=True
                break

        if repeat == False:
            
            c.append(s1)
            c.append(s2)
            p1=population[s1]
            p2=population[s2]
            
            o1=[]
            o2=[]

            for i in range(NUM_CITIES):
                o1.append("x")
                o2.append("x")

            population[s1]=cycle_crossover_operator(o1,p1,p2)
            population[s2]=cycle_crossover_operator(o2,p2,p1)

    return c          

def cycle_crossover_operator(o,p1,p2):

    i=0
    o[i]=p1[i]
    cycle=True
            
    while cycle:

        for k in range(NUM_CITIES):
            if p2[i] == o[k]:
                cycle=False
                break  

        for j in range(NUM_CITIES):
            if p2[i]==p1[j]:
                o[j]=p1[j]
                i=j
                break

    for j in range(NUM_CITIES):
        if o[j]=="x":
            o[j]=p2[j]

    return o;
    
def plot_cities(pos):
    
    x=[row[0] for row in pos]
    y=[row[1] for row in pos]

    plt.title("Cities")
    plt.xlabel("X") 
    plt.ylabel("Y") 
    plt.xticks(rotation=90) 
    plt.plot(x,y, 'g^')
    plt.plot(x,y)
    #plt.show()

    fig = plt.gcf() 
    fig.subplots_adjust(bottom=0.2)
    fig.savefig("cities.png", format='png')


def main():

    cities=generate_cities()
    print(cities)
    population=generate_random_population()

    for i in range(NUM_GENERATIONS):
        print("Generation", i)
        fitness=calcuate_fitness(population,cities)
        # print(cities)
        bubble_sort(fitness, population)
        reproduce(fitness,population)

        #for i in range(len(fitness)):
        #    print(population[i],fitness[i])

        mutated=mutate(population)
        c=crossover(population,mutated)

    fitness=calcuate_fitness(population,cities)
    min_fitness(population,fitness,cities)
   

    

##    print("")
##    print(mutated)
##    j=0
##    for i in range(len(fitness)):
##        for j in range(len(mutated)):
##            if mutated[j]==i:
##                print(population[i],mutated[j])
##                break
##    
##    print("")
##    print(c)
##    j=0
##    for i in range(len(fitness)):
##        for j in range(len(c)):
##            if c[j]==i:
##                print(population[i],c[j])
##                break

if __name__=="__main__":
    main()
