# Three layer ANN for
# OCR recognition of
# numbers
# Grey, 27 May 2019

import math
import unittest
from training_testing_data import *
import random
import numpy as np

def sigmoid(x):
    return 1 / (1 + math.exp(-x))

def sigmoid_derivative(x):
    return x * (1 - x)

def ann_testing(testing_input,testing_output):

    num_inputs=len(testing_input[0])
    num_layer2=len(testing_output[0])
    num_samples=len(testing_input)
    num_layer1=len(testing_wgt0[0])

    l1=[[0 for i in range(num_layer1)] for j in range(num_samples)]
    l1_delta=[[0 for i in range(num_layer1)] for j in range(num_samples)]
    l2=[[0 for i in range(num_layer2)] for j in range(num_samples)]
    l2_delta=[[0 for i in range(num_layer2)] for j in range(num_samples)]
    s1=[[0 for i in range(num_layer1)] for j in range(num_samples)]
    s2=[[0 for i in range(num_layer2)] for j in range(num_samples)]

    for k in range(num_layer1):
        for j in range(num_samples):  
            for i in range(num_inputs):
                s1[j][k]=s1[j][k]+testing_wgt0[i][k]*testing_input[j][i]
    
    for k in range(num_layer1):
        for j in range(num_samples):
            l1[j][k]=sigmoid(s1[j][k])

    for k in range(num_layer2):
        for j in range(num_samples):  
            for i in range(num_layer1):
                s2[j][k]=s2[j][k]+testing_wgt1[i][k]*l1[j][i]

    for k in range(num_layer2):
        for j in range(num_samples):
            l2[j][k]=sigmoid(s2[j][k])


    for k in range(num_layer2):
        for j in range(num_samples):
            if l2[j][k] >= 0.5:
                l2[j][k]=1
            elif  l2[j][k] < 0.5:
                l2[j][k]=0

    return l2


def ann_training(training_input,training_output,wgt0,wgt1):

    num_inputs=len(training_input[0])
    num_layer2=len(training_output[0])
    num_samples=len(training_input)
    num_layer1=len(wgt0[0])

    #print(num_inputs,num_layer2,num_samples,num_layer1)

    l1=[[0 for i in range(num_layer1)] for j in range(num_samples)]
    l1_delta=[[0 for i in range(num_layer1)] for j in range(num_samples)]
    l2=[[0 for i in range(num_layer2)] for j in range(num_samples)]
    l2_delta=[[0 for i in range(num_layer2)] for j in range(num_samples)]
    l2_error=[[0 for i in range(num_layer2)] for j in range(num_samples)]

    for iteration in range(60000):

        s1=[[0 for i in range(num_layer1)] for j in range(num_samples)]
        s2=[[0 for i in range(num_layer2)] for j in range(num_samples)]
        l1_error=[[0 for i in range(num_layer1)] for j in range(num_samples)]
        

        for k in range(num_layer1):
            for j in range(num_samples):  
                for i in range(num_inputs):
                    s1[j][k]=s1[j][k]+wgt0[i][k]*training_input[j][i]
    
        for k in range(num_layer1):
            for j in range(num_samples):
                l1[j][k]=sigmoid(s1[j][k])

        for k in range(num_layer2):
            for j in range(num_samples):  
                for i in range(num_layer1):
                    s2[j][k]=s2[j][k]  +wgt1[i][k]*l1[j][i]
                   
        for k in range(num_layer2):
            for j in range(num_samples):
                l2[j][k]=sigmoid(s2[j][k])
                l2_error[j][k]=training_output[j][k]-l2[j][k]
                l2_delta[j][k]=(l2_error[j][k])*sigmoid_derivative(l2[j][k])

        for k in range(num_layer2):
            for j in range(num_samples):  
                for i in range(num_layer1):
                    l1_error[j][i]=l1_error[j][i]+wgt1[i][k]*l2_delta[j][k]

        for k in range(num_layer1):
            for j in range(num_samples):
                l1_delta[j][k]=(l1_error[j][k])*sigmoid_derivative(l1[j][k])

        for k in range(num_layer1):
            for j in range(num_samples):  
                for i in range(num_inputs):
                    wgt0[i][k]=wgt0[i][k]+training_input[j][i]*l1_delta[j][k]

        for k in range(num_layer2):
            for j in range(num_samples):  
                for i in range(num_layer1):
                    wgt1[i][k]=wgt1[i][k]+l1[j][i]*l2_delta[j][k]

        if (iteration% 100) == 0:
            print ("Error:" + str(np.mean(np.abs(l2_error))))

    return l2, wgt0, wgt1

def train():
    wgt0 = [[random.uniform(-1.0, 1.0) for i in range(10)] for j in range(64)]
    wgt1 = [[random.uniform(-1.0, 1.0) for i in range(4)] for j in range(10)]
    l2, wgt0, wgt1=ann_training(training_input,training_output,wgt0,wgt1)
    print(l2)
    print(wgt0)
    print(wgt1)

def testing():
#    l2=ann_testing(training_input,training_output)
    l2=ann_testing(testing_input,testing_output)
    print(l2)
    print(testing_output)

def main():
    train()
    #testing()



class Test(unittest.TestCase):

    def test1(self):
        vals=[[0.002586891129799034], [0.9967086012671366], [0.997053598484977], [0.0038791661719737957]]
        training_input = [[0,0,1],[0,1,1],[1,0,1],[1,1,1]]
        training_output = [[0],[1],[1],[0]]
        wgt0=[[-0.2,  0.4, -1.0, -0.4],[-0.7, -0.8, -0.6, -0.3],[-0.2,  0.1, -0.2,  0.4  ]]
        wgt1=[[-0.6], [ 0.8], [-0.9],[ 0.3]]
        l2, wgt0, wgt1=ann_training(training_input,training_output,wgt0,wgt1)
        self.assertEqual(l2, vals)

if __name__=="__main__":
    #unittest.main()
    main()
